
class WhyChooseModel {
  String? whyChooseUrl;
  String? whyChooses3Url;
  List<Banners>? banners;

  WhyChooseModel({
    this.whyChooseUrl,
    this.whyChooses3Url,
    this.banners,
  });

  WhyChooseModel.fromJson(Map<String, dynamic> json) {
    whyChooseUrl = json['why_choose_url'];
    whyChooses3Url = json['why_choose_s3_url'];
    if (json['banners'] != null) {
      banners = <Banners>[];
      json['banners'].forEach((v) {
        banners!.add(Banners.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['why_choose_url'] = whyChooseUrl;
    data['why_choose_s3_url'] = whyChooses3Url;
    if (banners != null) {
      data['banners'] = banners!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Banners {
  int? id;
  int? moduleId;
  String? title;
  String? shortDescription;
  String? imageFullUrl;
  int? status;
  String? createdAt;
  String? updatedAt;
  List<Translations>? translations;

  Banners({
    this.id,
    this.moduleId,
    this.title,
    this.shortDescription,
    this.imageFullUrl,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.translations,
  });

  Banners.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    moduleId = json['module_id'];
    title = json['title'];
    shortDescription = json['short_description'];
    imageFullUrl = json['image_full_url'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    if (json['translations'] != null) {
      translations = <Translations>[];
      json['translations'].forEach((v) {
        translations!.add(Translations.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['module_id'] = moduleId;
    data['title'] = title;
    data['short_description'] = shortDescription;
    data['image_full_url'] = imageFullUrl;
    data['status'] = status;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    if (translations != null) {
      data['translations'] = translations!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Translations {
  int? id;
  String? translationableType;
  int? translationableId;
  String? locale;
  String? key;
  String? value;
  String? createdAt;
  String? updatedAt;

  Translations({
    this.id,
    this.translationableType,
    this.translationableId,
    this.locale,
    this.key,
    this.value,
    this.createdAt,
    this.updatedAt,
  });

  Translations.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    translationableType = json['translationable_type'];
    translationableId = json['translationable_id'];
    locale = json['locale'];
    key = json['key'];
    value = json['value'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['translationable_type'] = translationableType;
    data['translationable_id'] = translationableId;
    data['locale'] = locale;
    data['key'] = key;
    data['value'] = value;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    return data;
  }
}
